#include "ScnLoading.h"
#include "contentlist.h"
#include <xuiapp.h>

int i = 0;

HRESULT CScnLoading::OnInit( XUIMessageInit* pInitData, BOOL& bHandled )
{
	if (cl.Loaded)
	{
		HXUIOBJ hScene = NULL;
		HRESULT hResult = CXuiScene::SceneCreate( L"main.xur", &hScene );
		DebugMsg("CXuiScene::SceneCreate( main.xur, &hScene ) = %08x",hResult);
		hResult = CXuiScene::NavigateForward( hScene );
		DebugMsg("CXuiScene::NavigateForward( hScene ) = %08x",hResult);
	}

	SetTimer(TM_LOADING,50);

    GetChildById( L"CurrentThing", &m_current );
    GetChildById( L"Sub1Text", &m_sub1 );
    GetChildById( L"Sub2Text", &m_sub2 );
    GetChildById( L"Sub1Progress", &m_sub1pb );
    GetChildById( L"Sub2Progress", &m_sub2pb );

	m_sub1pb.SetShow(false);
	m_sub2pb.SetShow(false);

	return S_OK;
}

HRESULT CScnLoading::OnTimer( XUIMessageTimer *pTimer, BOOL& bHandled )
{
    // which timer is it?
    switch( pTimer->nId )
    {
        case TM_LOADING:
			{
				if (cl.Loaded)
				{
					KillTimer(TM_LOADING);

					HXUIOBJ hScene = NULL;
					HRESULT hResult = CXuiScene::SceneCreate( L"main.xur", &hScene );
					DebugMsg("CXuiScene::SceneCreate( main.xur, &hScene ) = %08x",hResult);
					hResult = CXuiScene::NavigateForward( hScene );
					DebugMsg("CXuiScene::NavigateForward( hScene ) = %08x",hResult);
				}

				lt->Lock();
				m_current.SetText(cl.current.c_str());

				if (cl.sub1.empty())
				{
					m_sub1.SetText(L"");
				} else {
					m_sub1.SetText(cl.sub1.c_str());
				}

				if (cl.sub1ProgMax > 0)
				{
					if (!m_sub1pb.IsShown())
						m_sub1pb.SetShow(true);
					m_sub1pb.SetRange(0,cl.sub1ProgMax);
					m_sub1pb.SetValue(cl.sub1ProgCur);
				} else {
					if (m_sub1pb.IsShown())
						m_sub1pb.SetShow(false);
				}

				if (cl.sub2.empty())
				{
					m_sub2.SetText(L"");
				} else {
					m_sub2.SetText(cl.sub2.c_str());
				}

				if (cl.sub2ProgMax > 0)
				{
					if (!m_sub2pb.IsShown())
						m_sub2pb.SetShow(true);
					m_sub2pb.SetRange(0,cl.sub2ProgMax);
					m_sub2pb.SetValue(cl.sub2ProgCur);
				} else {
					if (m_sub2pb.IsShown())
						m_sub2pb.SetShow(false);
				}
				lt->Unlock();

				//handle timer 0 for this object
            break;
			}
    }
    
    bHandled = TRUE;
    
    return( S_OK );
}